<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;

class StateSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $states = [
            [
                'country_id' => 1,
                'name' => 'Badakhshan',
                'code' => 'BDS',
                'status' => true,
            ],
            [
                'country_id' => 1,
                'name' => 'Badghis',
                'code' => 'BDG',
                'status' => true,
            ],
            [
                'country_id' => 1,
                'name' => 'Baghlan',
                'code' => 'BGL',
                'status' => true,
            ],
            [
                'country_id' => 1,
                'name' => 'Balkh',
                'code' => 'BLK',
                'status' => true,
            ],
            [
                'country_id' => 1,
                'name' => 'Bamyan',
                'code' => 'BMY',
                'status' => true,
            ],
            [
                'country_id' => 1,
                'name' => 'Daykundi',
                'code' => 'DYK',
                'status' => true,
            ],
            [
                'country_id' => 1,
                'name' => 'Farah',
                'code' => 'FRH',
                'status' => true,
            ],
            [
                'country_id' => 1,
                'name' => 'Faryab',
                'code' => 'FYB',
                'status' => true,
            ],
            [
                'country_id' => 1,
                'name' => 'Ghazni',
                'code' => 'GZ',
                'status' => true,
            ],
            [
                'country_id' => 1,
                'name' => 'Ghor',
                'code' => 'GR',
                'status' => true,
            ],
            [
                'country_id' => 1,
                'name' => 'Helmand',
                'code' => 'HLM',
                'status' => true,
            ],
            [
                'country_id' => 1,
                'name' => 'Herat',
                'code' => 'HRT',
                'status' => true,
            ],
            [
                'country_id' => 1,
                'name' => 'Jowzjan',
                'code' => 'JW',
                'status' => true,
            ],
            [
                'country_id' => 13,
                'name' => 'Dhaka',
                'code' => 'DHK',
                'status' => true,
            ],
            [
                'country_id' => 13,
                'name' => 'Chittagong',
                'code' => 'CGP',
                'status' => true,
            ],
            [
                'country_id' => 13,
                'name' => 'Khulna',
                'code' => 'KHL',
                'status' => true,
            ],
            [
                'country_id' => 13,
                'name' => 'Rajshahi',
                'code' => 'RAJ',
                'status' => true,
            ],
            [
                'country_id' => 13,
                'name' => 'Barisal',
                'code' => 'BAR',
                'status' => true,
            ],
            [
                'country_id' => 13,
                'name' => 'Sylhet',
                'code' => 'SYL',
                'status' => true,
            ],
            [
                'country_id' => 13,
                'name' => 'Rangpur',
                'code' => 'RGP',
                'status' => true,
            ],
            [
                'country_id' => 13,
                'name' => 'Mymensingh',
                'code' => 'MYM',
                'status' => true,
            ],
            [
                'country_id' => 13,
                'name' => 'Dinajpur',
                'code' => 'DIN',
                'status' => true,
            ],
            [
                'country_id' => 13,
                'name' => 'Comilla',
                'code' => 'COM',
                'status' => true,
            ],
            [
                'country_id' => 13,
                'name' => 'Jessore',
                'code' => 'JES',
                'status' => true,
            ],
            [
                'country_id' => 13,
                'name' => 'Bogra',
                'code' => 'BOG',
                'status' => true,
            ],
            [
                'country_id' => 13,
                'name' => 'Brahmanbaria',
                'code' => 'BRA',
                'status' => true,
            ],
            [
                'country_id' => 13,
                'name' => 'Tangail',
                'code' => 'TAN',
                'status' => true,
            ],
        ];

        foreach ($states as $state) {
            \App\Models\State::updateOrCreate([
                'name' => $state['name'],
                'country_id' => $state,
            ], $state);
        }
    }
}
